using System;
using Server;
using Server.Items;
using Server.Spells;

namespace Server.Mobiles
{
	//[CorpseName( "a shimmering effusion corpse" )]
	public class ShimmeringEffusion : BaseCreature
	{
		private bool IsMLBoss;
		
      [Constructable]
		public ShimmeringEffusion() : this ( true )
		{
		}
		
      [Constructable]
		public ShimmeringEffusion( bool ismlboss ) : base( AIType.AI_Mage, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			IsMLBoss = ismlboss;
         Name = "a shimmering effusion";
			Body = 0x105;			

			SetStr( 509, 538 );
			SetDex( 354, 381 );
			SetInt( 1513, 1578 );

			SetHits( 8000 );

			SetDamage( 27, 31 );
			
			SetDamageType( ResistanceType.Physical, 20 );
			SetDamageType( ResistanceType.Fire, 20 );
			SetDamageType( ResistanceType.Cold, 20 );
			SetDamageType( ResistanceType.Poison, 20 );
			SetDamageType( ResistanceType.Energy, 20 );
			
			SetResistance( ResistanceType.Physical, 75, 76 );
			SetResistance( ResistanceType.Fire, 60, 65 );
			SetResistance( ResistanceType.Cold, 60, 70 );
			SetResistance( ResistanceType.Poison, 76, 80 );
			SetResistance( ResistanceType.Energy, 75, 78 );

			SetSkill( SkillName.Wrestling, 100.2, 101.4 );
			SetSkill( SkillName.Tactics, 105.5, 102.1 );
			SetSkill( SkillName.MagicResist, 150 );
			SetSkill( SkillName.Magery, 150.0 );
			SetSkill( SkillName.EvalInt, 150.0 );
			SetSkill( SkillName.Meditation, 120.0 );
			
			Fame = 24000;
			Karma = -10000;

			VirtualArmor = 100;

			PackItem( new RandomTalisman() );
			PackItem( new Tokens( Utility.RandomMinMax( 15, 25 ) ) );
		}
		
		public override void GenerateLoot()
		{
			AddLoot( LootPack.AosSuperBoss, 2 );
			AddLoot( LootPack.AosFilthyRich );
		}		
		
		public override void OnDeath( Container c )
		{
			base.OnDeath( c );
			
			if ( IsMLBoss )
			{
				c.DropItem( new CapturedEssence() );
				c.DropItem( Loot.RandomArcanistScroll() );
         }
			
// 			c.DropItem( new CapturedEssence() );
// 			c.DropItem( new ShimmeringCrystals() );			
// 			
// 			if ( Utility.RandomDouble() < 0.05 )
// 			{
// 				switch ( Utility.Random( 4 ) )
// 				{
// 					case 0: c.DropItem( new ShimmeringEffusionStatuette() );	break;
// 					case 1: c.DropItem( new CorporealBrumeStatuette() );	break;
// 					case 2: c.DropItem( new MantraEffervescenceStatuette() ); break;
// 					case 3: c.DropItem( new FetidEssenceStatuette() ); break;
// 				}
// 			}
// 			
// 			if ( Utility.RandomDouble() < 0.05 )
// 				c.DropItem( new FerretImprisonedInCrystal() );		
						
			if ( Utility.RandomDouble() < 0.02 )
				c.DropItem( new CrystallineRing() );	
					
			if ( Utility.RandomDouble() < 0.02 )
				c.DropItem( new CrimsonCinture() );
				
// 			if ( 0.5 > Utility.RandomDouble() )
// 			{
// 				switch ( Utility.Random( 4 ) )
// 				{
// 					case 0: AddToBackpack( new MalekisHonor() ); break;
// 					case 1: AddToBackpack( new Feathernock() ); break;
// 					case 2: AddToBackpack( new Swiftflight() ); break;
// 					case 3: AddToBackpack( new HunterGloves() ); break;
// 				}
// 			}		
			
// 			if ( Utility.RandomDouble() < 0.6 )				
// 				c.DropItem( new ParrotItem() );
		}
		
		public override void OnKilledBy( Mobile mob )
		{
			base.OnKilledBy( mob );

			if ( IsMLBoss && Paragon.CheckArtifactChance( mob, this ) )
			{
				Paragon.GiveMLArtifactTo( mob );
			}
		}
		
		public override void OnGotMeleeAttack( Mobile attacker )
		{
			base.OnGotMeleeAttack( attacker );
			
			if ( Utility.RandomDouble() < 0.05 )
				Summon();
		}
		
		public override void OnDamagedBySpell( Mobile attacker )
		{
			base.OnDamagedBySpell( attacker );
			
			if ( Utility.RandomDouble() < 0.05 )
				Summon();
		}

		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		public override Poison PoisonImmune{ get{ return Poison.Lethal; } }
		public override bool AutoDispel{ get{ return true; } }
		public override int TreasureMapLevel{ get{ return 5; } }
		public override bool BardImmune{ get{ return true; } }
		public override bool Unprovokable{ get{ return true; } }
		public override bool Uncalmable{ get{ return true; } }
		#region Fire Ring
		public virtual bool HasFireRing{ get{ return true; } }
		public virtual double FireRingChance{ get{ return 1.0; } }
		private DateTime m_NextFireRing = DateTime.Now;
		

    
      private static int[] m_Tiles = new int[]
		{
			-2, 0,
			2, 0,
			2, -2,
			2, 2,
			-2, -2,
			-2, 2,
			0, 2,
			1, 0,
			0, -2
		};
		
		public virtual void FireRing()
		{
			for ( int i = 0; i < m_Tiles.Length; i += 2 ) 
			{
				Point3D p = Location;
				
				p.X += m_Tiles[ i ];
				p.Y += m_Tiles[ i + 1 ];
				
				IPoint3D po = p as IPoint3D;
				
				SpellHelper.GetSurfaceTop( ref po );
				
				Effects.SendLocationEffect( po, Map, Utility.RandomBool() ? 0x3E31 : 0x3E27, 100 );
			}
			m_NextFireRing = DateTime.Now + TimeSpan.FromSeconds( 10 );
		}
		
		#endregion
		public override int GetIdleSound() { return 0x1BF; }
		public override int GetAttackSound() { return 0x1C0; }
		public override int GetHurtSound() { return 0x1C1; }
		public override int GetDeathSound()	{ return 0x1C2; }

		public ShimmeringEffusion( Serial serial ) : base( serial )
		{
		}	

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			
			int version = reader.ReadInt();
		}
		
		public virtual void Summon()
		{
			int amount = 1;
		
// 			if ( Altar != null )
// 				amount = Altar.Fighters.Count;
				
// 			if ( amount > 5 )
// 				amount = 5;
			
			for ( int i = 0; i < amount; i ++ )
			{
				Mobile summon = null;
				
				switch ( Utility.Random( 2 ) )
				{
					case 0: summon = new MantraEffervescence(); break;
					case 1: summon = new CorporealBrume(); break;
					case 2: summon = new FetidEssence(); break;
				}				
				
				summon.MoveToWorld( Location, Map );
			}
		}
	}
}
